#version 140
#extension GL_EXT_gpu_shader4 : enable
//camino onduladoMod01.fsh  by jorge2017a1
//https://www.shadertoy.com/view/WtSczt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1-


#define MAX_STEPS 100
#define MAX_DIST 100.
#define SURF_DIST .001
//----common----//
///------------------------------------
struct TObj
{
    float tipo;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 rf;
   
};


TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;



#define PI 3.14159265358979323846264
#define PI2 6.28318530717
#define TriplePI (3.0 * PI)
#define DoublePI (2.0 * PI)
#define HalfPI (PI / 2.0)



///--------------------------------------------
///----------Orbit Camera
///---------https://www.shadertoy.com/view/WlVGD1
///----------Creditos de : spalmer en 2020-01-12
///--------------------------------------------INICIO
const float orbit_scale = 4.0; // of radius of object
const float radius = 15.0; // of object resting on ground to examine

vec2 StoQ(vec2 s, vec2 r)
{
	return (s + s - r) / r.y; 
}

mat3 CameraMatrix(vec3 camFwd)
{
    vec3 w = normalize(camFwd)
       , u = normalize(cross(vec3(0., 1., 0.), w))
       , v = normalize(cross(w, u));
    return mat3(u, v, w);
}


vec3 sph2cart(vec3 a) // spherical radians theta, psi, radius -> cartesian
{
    float cx = cos(a.x), sx = sin(a.x)
        , cy = cos(a.y), sy = sin(a.y);
    return vec3(sx*cy, sy, cx*cy) * a.z;
}

vec3 OrbitCamera(vec2 angles)
{ // angles is yaw, pitch in radians
    angles.x *= 2.; // kludge because Shadertoys clip mouse to window
    angles.y = clamp(angles.y, -.4, .3);
    return sph2cart(vec3(angles * PI, 1.));
} 

///--------------------------------------------FIN
///--------------------------------------------







///Gracias por la Ayuda de SHane...16-jun-2020
// Creditos a Shane por su funcion tex3D
// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: http://http.developer.nvidia.com/GPUGems3/gpugems3_ch01.html
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    
    // Ryan Geiss effectively multiplies the first line by 7. It took me a while to realize that 
    // it's largely redundant, due to the division process that follows. I'd never noticed on 
    // account of the fact that I'm not in the habit of questioning stuff written by Ryan Geiss. 
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    //n /= length(n); 
    
    // Texure samples. One for each plane.
    vec3 tx = texture(tex, p.yz).xyz;
    vec3 ty = texture(tex, p.zx).xyz;
    vec3 tz = texture(tex, p.xy).xyz;
    
    // Multiply each texture plane by its normal dominance factor.... or however you wish
    // to describe it. For instance, if the normal faces up or down, the "ty" texture sample,
    // represnting the XZ plane, will be used, which makes sense.
    
    // Textures are stored in sRGB (I think), so you have to convert them to linear space 
    // (squaring is a rough approximation) prior to working with them... or something like that. 
    // Once the final color value is gamma corrected, you should see correct looking colors.
    return mat3(tx*tx, ty*ty, tz*tz)*n; // Equivalent to: tx*tx*n.x + ty*ty*n.y + tz*tz*n.z;

}





//-ooooooooooooooooooooooooooooooooooooooooooooooooooooo
//https://www.shadertoy.com/view/XlBXWw
vec2 hash22(vec2 p) 
{ 
    float n = sin(dot(p, vec2(41, 289)));
    return fract(vec2(262144, 32768)*n); 
    
}

float Voronoi(vec2 p)
{	
    // Partitioning the 2D space into repeat cells.
    vec2 ip = floor(p); // Analogous to the cell's unique ID.
    p -= ip; // Fractional reference point within the cell (fract(p)).
    float d = 1.;
    
    for (int i = -1; i <= 1; i++){
	    for (int j = -1; j <= 1; j++){
	    
     	    vec2 cellRef = vec2(i, j); // Base cell reference point.
            
            vec2 offset = hash22(ip + cellRef); // 2D offset.
            
            // Vector from the point in the cell to the offset point.
            vec2 r = cellRef + offset - p; 
            float d2 = dot(r, r); // Squared length of the vector above.
            
            d = min(d, d2); // If it's less than the previous minimum, store it.
        }
    }
    
    // In this case, the distance is being returned, but the squared distance
    // can be used too, if preferred.
    return sqrt(d); 
}
///oooooooooooooooooooooooooooooooooooooooooooooooooooooo


//----------------
///https://www.shadertoy.com/view/wsjBD3

float sdcirclevec2(vec2 p, float r) {
  return length(p) - r;
}

vec2 mod2(inout vec2 p, vec2 size) 
{
  vec2 c = floor((p + size*0.5)/size);
  p = mod(p + size*0.5,size) - size*0.5;
  return c;
}

vec2 hashvec2(vec2 p) {
  p = vec2(dot (p, vec2 (127.1, 311.7)), dot (p, vec2 (269.5, 183.3)));
  return -1. + 2.*fract (sin (p)*43758.5453123);
}

float noise1(vec2 p)
{
   const float cellWidth     = 1.0;
  vec2 n = mod2(p, vec2(cellWidth));
  vec2 hh = hashvec2(sqrt(2.0)*(n+1000.0));
  hh.x *= hh.y;
  
  float r = 0.225*cellWidth;
 
  float d = sdcirclevec2(p, 2.0*r);
  
  float h = hh.x*smoothstep(0.0, r, -d);

  return h*0.25;
}

//--------------------------------
    


float random() 
{
	return fract(sin(dot(mObj.uv, vec2(12.9898, 78.233)) ) * 43758.5453);
}





vec3 checkerBoard(float u, float v, float interval)
{
    float uu = floor(u/interval*2.0);
    float vv = floor(v/interval*2.0);
    float p =mod(uu+vv,2.0);
    return vec3(0.1+0.9*p);
}




//-------------------
//IQs noise
float noise(vec3 rp) {
    vec3 ip = floor(rp);
    rp -= ip; 
    vec3 s = vec3(7, 157, 113);
    vec4 h = vec4(0.0, s.yz, s.y + s.z) + dot(ip, s);
    rp = rp * rp * (3.0 - 2.0 * rp); 
    h = mix(fract(sin(h) * 43758.5), fract(sin(h + s.x) * 43758.5), rp.x);
    h.xy = mix(h.xz, h.yw, rp.y);
    return mix(h.x, h.y, rp.z); 
}


vec3 wave_color(float d, float s, vec2 uv )
{
    float b = 0.001;
    // border
    float bw = 0.08;
    float innergray =
        mix(.5,0.,smoothstep(-0.01,0.01,d))
      + mix(.0,1.,smoothstep(bw,2.*bw,d));
    vec3 blue = vec3(
        vec2(s) + 0.2*length(0.2*uv)        , 1.);
    vec3 white = vec3(1.);
    return mix(white, blue, 2.*innergray);
}
    

//----------------------------------------

///-----------------------------------------
//----------------------------------------------------


vec3 getColor(int i)
{
    
    float m;
        
if (i==0 ) { return vec3(0,0,0)/255.0; }
if (i==1 ) { return vec3(255.,255.,255.)/255.0; }
if (i==2 ) { return vec3(255,0,0)/255.0; }
if (i==3 ) { return vec3(0,255,0)/255.0; }
if (i==4 ) { return vec3(0,0,255)/255.0; }
if (i==5 ) { return vec3(255,255,0)/255.0; }
if (i==6 ) { return vec3(0,255,255)/255.0; }
if (i==7 ) { return vec3(255,0,255)/255.0; }
if (i==8 ) { return vec3(192,192,192)/255.0; }
if (i==9 ) { return vec3(128,128,128)/255.0; }
if (i==10 ) { return vec3(128,0,0)/255.0; }
if (i==11 ) { return vec3(128,128,0)/255.0; }
if (i==12 ) { return vec3(0,128,0)/255.0; }
if (i==13 ) { return vec3(128,0,128)/255.0; }
if (i==14 ) { return vec3(0,128,128)/255.0; }
if (i==15 ) { return vec3(0,0,128)/255.0; }
    
if (i==16 ) { return vec3(255, 204, 188)/255.0; }
if (i==17 ) { return vec3(0.8, 0.8, 0.8); }
if (i==18 ) { return vec3(0.5, 0.5, 0.8); }

    if(i== 19 )
    {  return vec3(1, 0.5, 0);    } 
    if(i== 20 )
    { return vec3(1.0, 1.0, 1.0); } 
    if(i== 21 )
    {  return vec3(247./255., 168./255.,  184./255.);  } 
    if(i== 22 )
    { return vec3(0, 1, 1);} 
    if(i== 23 )
    { return vec3(85./255., 205./255., 252./255.); } 
    
    
    
      
    if(i== 50 )
    {
     
           vec3 p = glpRoRd;
            //vec3 p = mObj.p;
        	//vec3 p =  mObj.normal*0.5;
           vec3 marbleP = p*2.0;
    
            marbleP.x += sin(p.y*0.5)*0.12;
            marbleP.z += sin(p.y*2.0)*0.1;
            marbleP.y += sin(p.x*5.0)*0.13;
            marbleP.y += sin(p.z*3.0)*0.14;

            marbleP.y += sin(p.x*1.3)*0.5;
            marbleP.y += sin(p.z*1.5)*0.6;

            marbleP.x += sin(p.y*10.0)*0.011;
            marbleP.z += sin(p.y*12.0)*0.013;
            marbleP.y += sin(p.x*15.0)*0.012;
            marbleP.y += sin(p.z*13.0)*0.015;

            marbleP.x *= 0.5;
            marbleP.z *= 0.8;
            marbleP.y *= 0.50;

            float marbleAmtA = abs(sin(marbleP.x)+sin(marbleP.y)+sin(marbleP.z))/3.0;
            marbleAmtA = pow(1.0-marbleAmtA,5.0);

            marbleP = p;

            marbleP.x += sin(p.y*21.0)*0.12;
            marbleP.z += sin(p.y*23.0)*0.1;
            marbleP.y += sin(p.x*22.0)*0.13;
            marbleP.y += sin(p.z*24.0)*0.14;

            marbleP.y += sin(p.x*1.2)*0.5;
            marbleP.y += sin(p.z*1.4)*0.6;

            marbleP.x += sin(p.y*150.0)*0.011;
            marbleP.z += sin(p.y*162.0)*0.013;
            marbleP.y += sin(p.x*145.0)*0.012;
            marbleP.y += sin(p.z*153.0)*0.015;

            marbleP.x *= 0.2;
            marbleP.z *= 0.3;
            marbleP.y *= 0.10;

            float marbleAmtB = abs(sin(marbleP.x)+sin(marbleP.y)+sin(marbleP.z))/3.0;
            marbleAmtB = pow(1.0-marbleAmtB,9.0);
            marbleAmtB = 1.0-(1.0-marbleAmtB*0.3);

            float marbleAmt = marbleAmtA + marbleAmtB;
            marbleAmt = clamp(marbleAmt,0.0,1.0);
			vec3 surfaceColor;
            
    	
        	surfaceColor = mix(vec3(0.4,0.4,0.6),vec3(0.50,0.1,0.2),marbleAmtA);
        
        	return surfaceColor;	
        
			}  
    
    
    if (i==51)
    { 
        vec2 p=mObj.p.xz;
        float vo= Voronoi(p);
     	vec3 col= mix( vec3(0.25, 0.25, 0.25)*vo, vec3(0.26,0.54,1.0),vo); 
        return col;
    } 
    
    
    if (i==52)
    { 
        vec2 p=mObj.p.xz;
        float vo= Voronoi(p);
        float no1= noise1(p);
        vo=vo*no1*10.5;
     	vec3 col= mix( vec3(0.25, 0.25, 0.25)*vo, vec3(0.26,0.54,1.0),vo); 
        return col;
    } 
	
	
    
    if (i==53)
    { 
    	return  wave_color( mObj.dist, 0.22, mObj.uv );
    }    
    
    
    
    
    //////// Colorization

}

///--------------------------------------------

//end common----//
//start image//
vec3 light_pos1   ;
vec3 light_color1 ;
vec3 light_pos2   ;
vec3 light_color2 ;

#define  mangulo 45.0
    
    
//Torus function
float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}


//Sphere function

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

//Box function
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0))
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}


float sdRoundBox( vec3 p, vec3 b, float r )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r;
}

///---------------------------------------
float intersectSDF(float distA, float distB) {
    return max(distA, distB);
}

float unionSDF(float distA, float distB) 
{
    return min(distA, distB);
}

float differenceSDF(float distA, float distB) 
{
    return max(distA, -distB);
}


vec2 opU(vec2 d1, vec2 d2 ) {
  vec2 resp;
    if (d1.x < d2.x){ 
        resp = d1;
    }
    else
    {
        resp = d2;
    }
     
   return resp; 
}
///------------------------------------


vec3 rotate_y(vec3 v, float angle)
{
	float ca = cos(angle); float sa = sin(angle);
	return v*mat3(
		ca, 0.0, -sa,
		0.0, 1.0, 0.0,
		sa, 0.0, ca);
}

vec3 rotate_x(vec3 v, float angle)
{
	float ca = cos(angle); float sa = sin(angle);
	return v*mat3(
		1.0, 0.0, 0.0,
		0.0, ca, -sa,
		0.0, sa, ca);
}


vec3 rotate_z(vec3 v, float angle)
{
	float ca = cos(angle); 
    float sa = sin(angle);
	return v*mat3(
		ca, -sa, 0.0,
		sa, ca, 0.0,
		0.0, 0.0, 1.0);
}

///-----------------------------------------


vec3 LightShading(vec3 Normal,vec3 toLight,vec3 toEye,vec3 color)
{
    vec3 toReflectedLight=reflect(-toLight, Normal);
    vec3 diffuse = max(0.,dot(Normal,-toLight))*color;
    //vec3 specular = pow(max(0.,dot(Normal,normalize(-toLight-V))),100.)*vec3(1.,1.,1.); 
    float specularf=max(dot(toReflectedLight, toEye),0.0);
    specularf=pow(specularf, 100.0);
    vec3 specular =specularf*vec3(1.0);
    
    return diffuse + specular;
}



///-----------------------------------
vec2 rotate(vec2 v, float a) {
   return vec2(cos(a)*v.x + sin(a)*v.y, -sin(a)*v.x + cos(a)*v.y);
}
//----------------------------------------------------

mat2 rotate(float a) 
{
	float c = cos(a);
	float s = sin(a);
	return mat2(c, s, -s, c);
}



vec3 caminowavev1(vec3 p, float freq)
{    
    //float noise1(vec2 p)
    vec3 p8=p;
    //p8.x+=freq*sin(p8.z*0.25)+2.0*noise1(p.xz)-1.0;
    //p8.x+=freq*sin(p8.z*0.25)-1.0;
    //p8.x+=freq*sin(p8.z*0.25)-1.0+random()*0.125;
    p8.x+=freq*sin(p8.z*0.25)-1.0;
    
    
    p8.z=mod(p8.x,2.5)-1.0;
    return p8;
} 


vec2 plataforma(vec3 p, vec3 med, float freq)
{    
    
    vec2 res=vec2(9999.9,-1.0);
    vec3 pcw=caminowavev1(p,freq);
    
    float sdb1A= sdBox(pcw- vec3(0.0,5.0,0.0), vec3(med.x, med.y+1.0,med.z+2.0 ) );
    float sdb1B= sdBox(pcw- vec3(0.0,5.0,0.0), vec3(med.x+15.0,med.y,med.z)); 
    
    float difAB= differenceSDF(sdb1B, sdb1A);
    
	 res =opU(res, vec2(difAB,3.0));    
    return res;
} 



///------------------------
float GetDist(vec3 p  ) 
{	

    float d, dif1, dif2;
    vec2 res;
    vec3 pp,p1, p2,p3;
    
    res = vec2(9999, 0);
    
    float planeDist1 = p.y+10.0;  //piso inf
    float planeDist2 = 50.0-p.y;  //piso sup
    float planeDist3 = p.x+30.0; //pared izq
    float planeDist4 = 30.0-p.x;  //pared der
    float planeDist5 = -p.z+40.0;  //pared atras
    float planeDist6 = p.z+40.0;  //pared atras
   
        
        
    //res =opU(res, vec2(planeDist1,100)); //inf
    //res =opU(res, vec2(planeDist2,100)); 
    //res =opU(res, vec2(planeDist3,100)); 
    //res =opU(res, vec2(planeDist4,100)); 
  	//res =opU(res, vec2(planeDist5,100)); 
    
    res =opU(res, vec2(planeDist1,0.0)); //inf
    
  
    
    float alto=3.0;
    vec2 pres0=plataforma(p-vec3(0.0,-1.0-2.0*alto,1.0),vec3(2.0,2.0*alto,5.0),1.5);
    vec2 pres1=plataforma(p-vec3(0.0,0.0+0.0*alto,0.0),vec3(5.0,alto,5.0),1.5);
    vec2 pres2=plataforma(p-vec3(0.0,2.0+1.0*alto,0.0),vec3(10.0,alto,5.0), 1.0);
    vec2 pres3=plataforma(p-vec3(0.0,3.0+2.0*alto,0.0),vec3(15.0,alto,5.0), 2.0);
    vec2 pres4=plataforma(p-vec3(0.0,3.0+5.0*alto,0.0),vec3(20.0,alto*5.0,5.0), 2.0);
    
    
    float idcolor=50.0;
    res =opU(res, vec2(pres0.x,idcolor));    
    res =opU(res, vec2(pres1.x,idcolor));    
    res =opU(res, vec2(pres2.x,idcolor));    
    res =opU(res, vec2(pres3.x,idcolor));    
    res =opU(res, vec2(pres4.x,idcolor));    
    
    
    res =opU(res, vec2(1.0,0.0)); 
    
    
    d = res.x;
    mObj.dist = res.x;
    mObj.tipo = res.y;
    
    return d;
}



//---------actualizacion por Shane---28-may-2020    ...gracias
float RayMarch(vec3 ro, vec3 rd) 
{
	
    // The extra distance might force a near-plane hit, so
    // it's set back to zero.
    float dO = 0.; 
    //Determines size of shadow
    for(int i=0; i<MAX_STEPS; i++) 
    {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
        dO += dS;
        
    }
    
    return dO;
}




//---------------------------------------------------

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    //Texture of white and black in image
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}





float GetLightPar(vec3 p, vec3 plig) {
    vec3 lightPos = plig;
    //Determine movement of light ex. shadow and light direction and diffusion
   
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*SURF_DIST*2., l );
    if(d<length(lightPos-p)) dif *= .1;
    
    return dif;
}


float saturate(float f)
{
	return clamp(f,0.0,1.0);
}


//----------------------------------------------------

// Single rotation function - return matrix
mat2 r2(float a){ 
  float c = cos(a); float s = sin(a); 
  return mat2(c, s, -s, c); 
}
//--------------------

// iMouse pos function - take in a vec3 like ro
// simple pan and tilt and return that vec3
vec3 get_mouse(vec3 ro) 
{
    float x = iMouse.xy==vec2(0) ? -.2 :
    	(iMouse.y / iResolution.y * .5 - 0.25) * PI;
    float y = iMouse.xy==vec2(0) ? .0 :
    	-(iMouse.x / iResolution.x * 1.0 - .5) * PI;
    float z = 0.0;

    ro.zy *= r2(x);
    ro.zx *= r2(y);
    
    return ro;
}


// phong shading
vec3 p_shadingv3( vec3 pos, vec3 normal, vec3 ro, vec3 rd, vec3 plight_pos1,  vec3 plight_color1 )
{
	// ...add lights here...
    
	float shininess = 1.25;
    
	
	vec3 final = vec3( 0.0 );
	
	vec3 ev = normalize( pos - ro );
	vec3 ref_ev = reflect( ev, normal );
	
	
		vec3 vl = normalize( plight_pos1 - pos );
	
		float diffuse  = max( 0.0, dot( vl, normal ) );
		float specular = max( 0.0, dot( vl, ref_ev ) );
		specular = pow( specular, shininess );
		
		
        final += plight_color1 * ( diffuse + specular );
        
    
    
	vec3 color = vec3(1.0);
    color = color * 0.75 + 0.25;
   
    color *= normal * .25 + .75;
    
    
    float ambient2 = 0.1;
    float diffuse2 = 0.5 * -dot(normal,rd);
    float specular2 = 1.0 * max(0.0, -dot(rd, reflect(rd,normal)));
    
    color *= vec3(ambient2 + diffuse2 + pow(specular2,5.0));

    //color *= smoothstep(12.0,6.0,length(pos));
    
    
    
    return (final+color)/2.0;
}


//-------------------------------
vec3 getColorTex( vec3 p, vec3 nor,  int i)
{
    
	if (i==100 ) { return tex3D(iChannel0, p/32., nor); }
	if (i==101 ) { return tex3D(iChannel1, p/32., nor); }
	if (i==102 ) { return tex3D(iChannel2, p/32., nor); }
	if (i==103 ) { return tex3D(iChannel3, p/32., nor); }
   
    
}


vec3 Getluz(vec3 p, vec3 ro, vec3 nor , vec3 colobj ,vec3 plight_pos)
{   
     
    vec3 lightPos = plight_pos;
    float intensity=1.0;
	const float shininess = 100.0;
	vec3 l = normalize( p-lightPos);
    vec3 v = normalize( p-ro);
    vec3 h = normalize(v + l);
    float diff = dot(nor, l);
    float spec = max(0.0, pow(dot(nor, h), shininess)) * float(diff > 0.0);
	vec3 result = LightShading(nor,l,v, colobj)*intensity;
    return result;
}
    



///---------------------------------------------

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
	
    itime=iTime;
    float t;
    t=mod(iTime*5.0,500.0);
   
    
 
 light_pos1   = vec3(10.0, 12.0, 10.0 ); 
 light_color1 = vec3( 1.0 );

 light_pos2   = vec3( 0.0, 15.0, 0.0 );
 light_color2 = vec3( 1.0, 1.0, 1.0 );
 
    
    
    
    
    
    
    vec3 ro=vec3(4.0,13.0+8.0*cos(t*0.25),-25.0+t);
    vec3 ptmp= caminowavev1(ro, 1.0);
    ro.x=ptmp.x-1.0;
        
    vec3 rd=normalize(vec3(uv,1.0));
    
    
    
  
    light_pos1+=ro;
    light_pos2+=ro;
    
    
    vec3 col = vec3(0);
    
    TObj Obj;
    
    mObj.uv=uv;
    mObj.rd=rd;
    mObj.ro=ro;

	 
    
    float d = RayMarch(ro, rd);
    Obj=mObj;
    
  
    vec3 p = (ro + rd * d ); 
    glpRoRd=p;
    mObj.p=p;
    
    
    mObj.dist =d;
    vec3 colobj;
    
    vec3 nor= GetNormal( p);
    mObj.normal=nor;
  
    
    
    colobj=getColor(int( Obj.tipo));
    
    
    
    vec3 coltex=getColorTex(p, nor, int( Obj.tipo));
    
    
    if (Obj.tipo>=100.0) 
 	{       
        colobj=coltex*1.5;
	} 
    

  float dif1=1.0;
   
    
   
    
    
    
   vec3 col2,col3;
    
    vec3 result;
    result=  Getluz( p,ro, nor, colobj ,light_pos1);
    result+= Getluz( p,ro, nor, colobj ,light_pos2);
    result/=1.25;
    col3=result;
    
    
     
  
    col= col3*dif1;
    
    /*
     vec3 r = reflect(rd,nor);
    float fac = length(sin(r*4.)*0.5+0.5)/sqrt(2.0);
    float frens = 1.-pow(dot(rd,nor),2.)*0.98;
    //col+= mix(vec3(0.025,0.025,0.025),colobj/2.0, fac) + pow(fac,50.)*frens*0.25;
    col= mix(vec3(0.025,0.025,0.025),col, fac) + pow(fac,50.)*frens*0.25;
    //col=col/2.0;
    */
  	
    //sugerencia por dean_the_coder,
    //col *= 1.0 - pow(d / 100.0, 1.5);
    col *= 1.0 - pow(d / 100.0, 3.5);
    
    
    col = pow(col, vec3(1.0/2.2));  
    
    gl_FragColor = vec4(col,1.0);

}
